﻿//////////////////////////////////////////////
// ScriptObjectInterpreterView.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkScripts
{
	class ScriptObjectInterpreterReference ;
}

/// Includes ---------------------------------

// nkScripts
#include "../Functions/FunctionParameterType.h"

// nkMemory
#include <NilkinsMemory/Pointers/UniquePtr.h>

/// Class ------------------------------------

namespace nkScripts
{
	class ScriptObjectInterpreterView
	{
		public :

			// Constructor, destructor
			ScriptObjectInterpreterView (FUNCTION_PARAMETER_TYPE type)
			:	_type (type)
			{
				// Nothing to do
			}

			virtual ~ScriptObjectInterpreterView () = default ;

			// Getters
			FUNCTION_PARAMETER_TYPE getType () const
			{
				return _type ;
			}

			// Conversion
			virtual ScriptObjectInterpreterReference* toReference () const = 0 ;

			// Allocation
			virtual nkMemory::UniquePtr<ScriptObjectInterpreterView> copy () const = 0 ;

		protected :
		
			// Type of data
			FUNCTION_PARAMETER_TYPE _type = FUNCTION_PARAMETER_TYPE::VOID ;
	} ;
}